package iit.com.rainfallmonitoringsystem;

import iit.com.rainfallmonitoringsystem.repository.RainfallRecordRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RainfallRecordService {

    @Autowired
    private RainfallRecordRepository rainfallRecordRepository;

    // Add new rainfall record
    public rainFallRecord addRainfallRecord(rainFallRecord rainfallRecord) {
        return rainfallRecordRepository.save(rainfallRecord);
    }

    // Update existing rainfall record
    public rainFallRecord updateRainfallRecord(Integer recordId, rainFallRecord rainfallRecord) {
        if (rainfallRecordRepository.existsById(recordId)) {
            return rainfallRecordRepository.save(rainfallRecord);
        }
        return null;  // Or throw an exception
    }
}

