package iit.com.rainfallmonitoringsystem.StationController;

import iit.com.rainfallmonitoringsystem.Station;
import iit.com.rainfallmonitoringsystem.StationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/stations")
public class StationController {

    @Autowired
    private StationService stationService;

    // Add a new station
    @PostMapping
    public Station addStation(@RequestBody Station station) {
        return stationService.addStation(station);
    }

    // Update an existing station
    @PutMapping("/{stationId}")
    public Station updateStation(@PathVariable String stationId, @RequestBody Station station) {
        return stationService.updateStation(Integer.valueOf(stationId), station);
    }

    // Deactivate a station
    @DeleteMapping("/{stationId}")
    public boolean deactivateStation(@PathVariable String stationId) {
        return stationService.deactivateStation(stationId);
    }

    // Get a station by its ID
    @GetMapping("/{stationId}")
    public Station getStationById(@PathVariable String stationId) {
        return stationService.getStationById(stationId);
    }

    // Get all stations (optional)
    @GetMapping
    public List<Station> getAllStations() {
        return stationService.getAllStations();
    }
}
