package iit.com.rainfallmonitoringsystem;

import iit.com.rainfallmonitoringsystem.repository.StationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class StationService {

    @Autowired
    private StationRepository stationRepository;

    // Add new station
    public Station addStation(Station station) {
        return stationRepository.save(station);
    }

    // Update existing station
    public Station updateStation(Integer stationId, Station station) {
        Optional<Station> existingStation = stationRepository.findById(stationId);
        if (existingStation.isPresent()) {
            station.setStationId(String.valueOf(stationId));
            return stationRepository.save(station);
        }
        return null;  // Or throw an exception
    }

    // Deactivate station (soft delete by not considering inactive stations in active stats)
    public boolean deactivateStation(String stationId) {
        Optional<Station> station = stationRepository.findById(Integer.valueOf(stationId));
        if (station.isPresent()) {
            // Set inactive flag or update accordingly (you can implement a "status" field for this)
            stationRepository.delete(station.get());
            return true;
        }
        return false;
    }

    // Find station by id
    public Station getStationById(String stationId) {
        return stationRepository.findById(Integer.valueOf(stationId)).orElse(null);
    }

    public List<Station> getAllStations() {
        return List.of();
    }
}

